package com.example.los_chatos.screens

import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.height
import androidx.compose.material3.Button
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp
import androidx.navigation.NavController
import androidx.navigation.compose.rememberNavController
import com.example.los_chatos.ui.theme.Los_chatosTheme

@Composable
fun WelcomeScreen(navController: NavController, isAdmin: Boolean, modifier: Modifier = Modifier) {
    Box(
        modifier = modifier.fillMaxSize(),
        contentAlignment = Alignment.Center
    ) {
        Column(horizontalAlignment = Alignment.CenterHorizontally) {
            Text(text = "¡Bienvenido!", fontSize = 24.sp)
            Spacer(modifier = Modifier.height(16.dp))
            if (isAdmin) {
                Button(onClick = { /* TODO: Navigate to reports screen */ }) {
                    Text("Generar Reportes")
                }
                Spacer(modifier = Modifier.height(8.dp))
            }
            Button(onClick = {
                navController.navigate("login") {
                    popUpTo(navController.graph.startDestinationId) {
                        inclusive = true
                    }
                }
            }) {
                Text("Cerrar sesión")
            }
        }
    }
}

@Preview(showBackground = true)
@Composable
fun WelcomeScreenPreview() {
    Los_chatosTheme {
        val navController = rememberNavController()
        WelcomeScreen(navController, isAdmin = true)
    }
}
